/*
 * Decompiled with CFR 0.152.
 */
package se.pp.softwolves.games;

import se.pp.softwolves.games.ConsoleInputDriver;
import se.pp.softwolves.games.GameEngine;
import se.pp.softwolves.games.GameInput;

public class Potion {
    public static void main(String[] args) {
        if (args.length > 0) {
            System.out.println("The Potion, a miniature adventure game.");
            System.out.println("Run without any arguments to start.");
            System.exit(1);
        }
        Potion.run();
    }

    private static void run() {
        GameEngine engine = new GameEngine();
        System.out.println(GameEngine.intro());
        ConsoleInputDriver inputdriver = new ConsoleInputDriver();
        GameInput input = new GameInput(inputdriver);
        int oldroom = 0;
        GameEngine.GameState exit = GameEngine.GameState.GAME_CONTINUES;
        do {
            if (oldroom != engine.currentRoom()) {
                oldroom = engine.currentRoom();
                String description = engine.describeRoom();
                System.out.println(description);
            }
            if (input.getInput()) {
                StringBuilder output = new StringBuilder();
                exit = engine.perform(input.verb, input.object, output);
                System.out.print(output.toString());
                continue;
            }
            System.out.println("An error occurred, terminating.");
            System.exit(1);
        } while (exit == GameEngine.GameState.GAME_CONTINUES);
        switch (exit) {
            case GAME_LOST: {
                System.out.println("GAME OVER!");
                break;
            }
            case GAME_WON: {
                System.out.println("Congratulations!");
            }
        }
        inputdriver.close();
    }
}

