/*
 * Decompiled with CFR 0.152.
 */
package se.pp.softwolves.games;

import se.pp.softwolves.games.GameData;
import se.pp.softwolves.games.GameObject;

public class GameRoom {
    static void printRoom(GameData data, StringBuilder output) {
        boolean seen = false;
        int mapdata = data.map[data.room - 1];
        String s = null;
        switch (data.room) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 30: {
                s = "You are in a forest. There are trees in every direction as far as the eye can see.";
                break;
            }
            case 4: 
            case 10: 
            case 16: 
            case 18: {
                s = "You are standing on a big plain. You hear the distant hum of motors from somewhere.";
                break;
            }
            case 12: {
                s = "You are standing on a big plain, next to a recycling station.";
                break;
            }
            case 5: 
            case 11: 
            case 17: 
            case 23: 
            case 24: {
                switch (data.roadvisit) {
                    case 0: 
                    case 1: {
                        ++data.roadvisit;
                    }
                    case 3: {
                        s = "You are standing on an autobahn. Several cars are passing passing by.";
                        break;
                    }
                    case 2: {
                        s = "You are standing on an autobahn. Suddenly you see a skateboarder pass by, grabbing a bottle of Coca Cola from a nearby car.";
                        ++data.roadvisit;
                        data.objects[20] = data.room;
                    }
                }
                break;
            }
            case 6: {
                s = "You are standing on the sea shore. The sea stretches out as far as the eye can see to the north and to the east.";
                break;
            }
            case 19: 
            case 25: {
                s = "You are inside the scientist's lab. You notice that he doesn't seem to put much energy in keeping it tidy.";
                break;
            }
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                s = "You are standing inside a big fortress. There are some spider webs in the corners, and a layer of dust on pretty much everything.";
                break;
            }
            case 22: {
                if ((mapdata & 4) == 0) {
                    s = "You are standing beside a big moat. There is no way to pass over it without lowering the drawbridge.";
                    break;
                }
                s = "You are standing beside a drawbridge leading to a big fortress.";
                break;
            }
            case 28: 
            case 29: {
                s = "You are standing on a dump. It stinks!";
                break;
            }
            default: {
                s = "Something is very wrong!";
            }
        }
        output.append(s);
        output.append('\n');
        for (int i = 0; i < 21; ++i) {
            if (data.objects[i] != data.room) continue;
            if (!seen) {
                output.append("You see:\n");
                seen = true;
            }
            output.append(GameObject.printObject(i));
            if (i == 16 && !data.seenscientist) {
                output.append(" He says: \"What are you doing here?\"");
                data.seenscientist = true;
            }
            output.append('\n');
        }
        output.append("Available exits: ");
        if ((mapdata & 1) != 0) {
            output.append('N');
        }
        if ((mapdata & 2) != 0) {
            output.append('S');
        }
        if ((mapdata & 8) != 0) {
            output.append('E');
        }
        if ((mapdata & 4) != 0) {
            output.append('W');
        }
        output.append('\n');
    }
}

