/*
 * Decompiled with CFR 0.152.
 */
package se.pp.softwolves.games;

import se.pp.softwolves.games.GameData;

public class GameObject {
    static final int NOT_A_WORD = -1;
    static final int STONE_PILL = 0;
    static final int STONE_1 = 1;
    static final int STONE_2 = 2;
    static final int STONE_3 = 3;
    static final int STONE_MISSION = 4;
    static final int STONE_5 = 5;
    static final int STONE_6 = 6;
    static final int STONE_7 = 7;
    static final int STONE_8 = 8;
    static final int PILL = 9;
    static final int SQUIRREL = 10;
    static final int COIN = 11;
    static final int COTTAGE = 12;
    static final int SWITCH = 13;
    static final int HUBCAP = 14;
    static final int KEY = 15;
    static final int SCIENTIST = 16;
    static final int ELIXIR = 17;
    static final int BOOK = 18;
    static final int DOOR = 19;
    static final int COKE = 20;
    static final int LAST_STONE = 8;
    static final String[] NOUNS = new String[]{"stone", "rock", "pill", "squirrel", "coin", "gold coin", "money", "cottage", "house", "door", "switch", "hub cap", "key", "door key", "scientist", "madman", "potion", "book", "bottle", "empty bottle", "coke", "coca cola"};
    static final int[] NOUNNUMS = new int[]{-1, -1, 9, 10, 11, 11, 11, 12, 12, 19, 13, 14, 15, 15, 16, 16, 17, 18, 20, 20, 20, 20};

    public static int objectFromWord(String noun, boolean checkInventory, GameData state) {
        int i;
        int j = -1;
        for (i = 0; i < NOUNS.length; ++i) {
            if (!noun.equals(NOUNS[i])) continue;
            j = i;
        }
        switch (j) {
            case -1: {
                return -1;
            }
            case 0: 
            case 1: {
                for (i = 0; i < 9; ++i) {
                    if (!state.findObject(i, checkInventory)) continue;
                    return i;
                }
                break;
            }
            default: {
                if (!state.findObject(NOUNNUMS[j], checkInventory)) break;
                return NOUNNUMS[j];
            }
        }
        return -1;
    }

    public static String printObject(int objNum) {
        String s = null;
        switch (objNum) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                s = "A stone.";
                break;
            }
            case 9: {
                s = "A pill.";
                break;
            }
            case 10: {
                s = "A squirrel.";
                break;
            }
            case 11: {
                s = "A gold coin.";
                break;
            }
            case 12: {
                s = "A cottage.";
                break;
            }
            case 13: {
                s = "A switch.";
                break;
            }
            case 14: {
                s = "A hub cap.";
                break;
            }
            case 15: {
                s = "A key.";
                break;
            }
            case 16: {
                s = "A scientist.";
                break;
            }
            case 17: {
                s = "A potion.";
                break;
            }
            case 18: {
                s = "A book.";
                break;
            }
            case 19: {
                s = "A door.";
                break;
            }
            case 20: {
                s = "Empty Coke bottle.";
            }
        }
        return s;
    }

    public static boolean movable(int objNum) {
        switch (objNum) {
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                return true;
            }
        }
        return false;
    }
}

