/*
 * Decompiled with CFR 0.152.
 */
package se.pp.softwolves.games;

import se.pp.softwolves.games.GameInputDriver;

public class GameInput {
    static final String[] VERBS = new String[]{"s", "n", "e", "w", "i", "take", "pick up", "lift", "read", "talk to", "unlock", "open", "turn", "hit", "punch", "kick", "kill", "pour", "empty", "drink", "throw", "look at", "look", "examine", "drop", "license", "licence", "quit", "exit"};
    static final GameVerb[] VERBNUMS = new GameVerb[]{GameVerb.S, GameVerb.N, GameVerb.E, GameVerb.W, GameVerb.I, GameVerb.TAKE, GameVerb.TAKE, GameVerb.LIFT, GameVerb.READ, GameVerb.TALKTO, GameVerb.UNLOCK, GameVerb.UNLOCK, GameVerb.TURN, GameVerb.HIT, GameVerb.HIT, GameVerb.HIT, GameVerb.KILL, GameVerb.POUR, GameVerb.POUR, GameVerb.DRINK, GameVerb.THROW, GameVerb.LOOK, GameVerb.LOOK, GameVerb.LOOK, GameVerb.DROP, GameVerb.LICENSE, GameVerb.LICENSE, GameVerb.QUIT, GameVerb.QUIT};
    GameInputDriver driver;
    GameVerb verb;
    String object;

    public GameInput(GameInputDriver driver) {
        this.driver = driver;
    }

    boolean getInput() {
        this.verb = GameVerb.NOT_A_WORD;
        boolean firstTry = true;
        block0: while (this.verb == GameVerb.NOT_A_WORD) {
            String input = this.driver.getLine(firstTry);
            if (input == null) {
                return false;
            }
            firstTry = false;
            for (int i = 0; i < VERBS.length; ++i) {
                if (!input.startsWith(VERBS[i]) || input.length() != VERBS[i].length() && input.charAt(VERBS[i].length()) != ' ') continue;
                this.verb = VERBNUMS[i];
                if (input.length() > VERBS[i].length()) {
                    this.object = input.substring(VERBS[i].length() + 1);
                    if (!this.object.startsWith("the ")) continue block0;
                    this.object = this.object.substring(4);
                    continue block0;
                }
                this.object = null;
                continue block0;
            }
        }
        return true;
    }

    public static enum GameVerb {
        NOT_A_WORD,
        N,
        S,
        E,
        W,
        I,
        TAKE,
        LIFT,
        READ,
        TALKTO,
        UNLOCK,
        TURN,
        HIT,
        KILL,
        POUR,
        DRINK,
        THROW,
        LOOK,
        DROP,
        LICENSE,
        QUIT;

    }
}

