/*
 * Decompiled with CFR 0.152.
 */
package se.pp.softwolves.games;

import se.pp.softwolves.games.GameData;
import se.pp.softwolves.games.GameInput;
import se.pp.softwolves.games.GameObject;
import se.pp.softwolves.games.GameRoom;

public class GameEngine {
    private GameData data = new GameData();
    private int objNum = -1;

    static String intro() {
        return "The Potion - a simple adventure\n==========\n\nCopyright 2002-2003,2013 Peter Krefting.\nA Softwolves Software Release.\nhttp://www.softwolves.pp.se/sw/\n\nThis program comes with ABSOLUTELY NO WARRANTY. This is free software, and you are welcome to redistribute it under certain conditions; type \"license\" for details.\n";
    }

    int currentRoom() {
        return this.data.room;
    }

    GameState perform(GameInput.GameVerb verb, String object, StringBuilder output) {
        this.objNum = -1;
        switch (verb) {
            case N: 
            case S: 
            case E: 
            case W: {
                return this.move(verb, output);
            }
            case I: {
                return this.inventory(output);
            }
            case LICENSE: {
                return this.license(output);
            }
            case QUIT: {
                return this.quit(output);
            }
        }
        if (object != null) {
            this.objNum = GameObject.objectFromWord(object, verb != GameInput.GameVerb.TAKE, this.data);
        }
        if (this.objNum == -1) {
            if (verb == GameInput.GameVerb.LOOK) {
                GameRoom.printRoom(this.data, output);
            } else {
                output.append("I do not see that here.\n");
            }
            return GameState.GAME_CONTINUES;
        }
        switch (verb) {
            case TAKE: {
                return this.take(output);
            }
            case LIFT: {
                return this.lift(output);
            }
            case READ: {
                return this.read(output);
            }
            case TALKTO: {
                return this.talkto(output);
            }
            case UNLOCK: {
                return this.unlock(output);
            }
            case TURN: {
                return this.turn(output);
            }
            case HIT: {
                return this.hit(output);
            }
            case KILL: {
                return this.kill(output);
            }
            case POUR: {
                return this.pour(output);
            }
            case DRINK: {
                return this.drink(output);
            }
            case THROW: {
                return this.throwObject(output);
            }
            case LOOK: {
                return this.look(output);
            }
            case DROP: {
                return this.drop(output);
            }
        }
        output.append("Say what?");
        return GameState.GAME_CONTINUES;
    }

    GameState move(GameInput.GameVerb verb, StringBuilder output) {
        if (this.data.seenscientist) {
            output.append("The scientist captures you.\n");
            return GameState.GAME_LOST;
        }
        int bitmap = 0;
        int offset = 0;
        switch (verb) {
            case N: {
                bitmap = 1;
                offset = -6;
                break;
            }
            case S: {
                bitmap = 2;
                offset = 6;
                break;
            }
            case E: {
                bitmap = 8;
                offset = 1;
                break;
            }
            case W: {
                bitmap = 4;
                offset = -1;
            }
        }
        if ((this.data.map[this.data.room - 1] & bitmap) != 0) {
            this.data.room += offset;
        } else {
            output.append("You cannot go that way.\n");
            return GameState.GAME_CONTINUES;
        }
        int bottles = 0;
        for (int i = 0; i < 2; ++i) {
            if (this.data.inventory[i] != 17 && this.data.inventory[i] != 20) continue;
            ++bottles;
        }
        if (bottles == 2) {
            switch (++this.data.bothbottles) {
                case 1: {
                    output.append("The potion is starting to heat up.\n");
                    break;
                }
                case 5: {
                    output.append("Some kind kind of reaction seems to be happening between the potion and what is left of the Coke.\n");
                    break;
                }
                case 10: {
                    output.append("You better get rid of one of the bottles before the potion explodes!\n");
                    break;
                }
                case 12: {
                    output.append("The potion explodes in your face!\n");
                    return GameState.GAME_LOST;
                }
            }
        } else {
            this.data.bothbottles = 0;
        }
        return GameState.GAME_CONTINUES;
    }

    GameState inventory(StringBuilder output) {
        boolean hasanything = false;
        output.append("You are carrying:\n");
        for (int i = 0; i < 2; ++i) {
            if (this.data.inventory[i] == -1) continue;
            output.append(GameObject.printObject(this.data.inventory[i])).append("\n");
            hasanything = true;
        }
        if (!hasanything) {
            output.append("Nothing.\n");
        }
        return GameState.GAME_CONTINUES;
    }

    GameState take(StringBuilder output) {
        switch (this.objNum) {
            case 9: {
                this.data.pilleaten = true;
                this.data.objects[9] = -1;
                output.append("You understand.\n");
                break;
            }
            case 0: {
                if (!this.data.pilleaten && -1 == this.data.objects[9]) {
                    output.append("You found a small pill beneath it.\n");
                    this.data.objects[9] = this.data.room;
                    break;
                }
            }
            default: {
                if (GameObject.movable(this.objNum)) {
                    if (!this.data.addInventory(this.objNum, output)) break;
                    output.append("Taken.\n");
                    break;
                }
                output.append("You cannot do that!\n");
            }
        }
        return GameState.GAME_CONTINUES;
    }

    GameState lift(StringBuilder output) {
        switch (this.objNum) {
            case 0: {
                if (this.data.pilleaten) break;
                return this.take(output);
            }
        }
        output.append("Nothing.\n");
        return GameState.GAME_CONTINUES;
    }

    GameState read(StringBuilder output) {
        switch (this.objNum) {
            case 4: {
                output.append("It says:\n").append("\"Save us from the evil scientist. ").append("Mix his evil drug with salt water. ").append("That is your mission.\"");
                break;
            }
            default: {
                output.append("Nothing.\n");
            }
        }
        return GameState.GAME_CONTINUES;
    }

    GameState talkto(StringBuilder output) {
        switch (this.objNum) {
            case 16: {
                output.append("The scientist says:\n").append("\"You will die with the rest!\" ").append("and laughs frantically.\n");
                break;
            }
            case 10: {
                if (this.data.pilleaten) {
                    output.append("The squirrel says:\n").append("\"You can now exit the forest\"\n");
                    this.data.map[2] = this.data.map[2] | 8;
                    break;
                }
            }
            default: {
                output.append("You cannot do that!\n");
            }
        }
        return GameState.GAME_CONTINUES;
    }

    GameState unlock(StringBuilder output) {
        boolean havekey = false;
        for (int i = 0; i < 2; ++i) {
            if (15 != this.data.inventory[i]) continue;
            havekey = true;
        }
        if (havekey) {
            switch (this.objNum) {
                case 12: {
                    output.append("You find a switch inside.\n");
                    this.data.objects[13] = this.data.room;
                    return GameState.GAME_CONTINUES;
                }
                case 19: {
                    output.append("It opens revealing a laboratory.\n");
                    this.data.map[19] = this.data.map[19] | 4;
                    return GameState.GAME_CONTINUES;
                }
            }
        }
        output.append("You cannot do that!\n");
        return GameState.GAME_CONTINUES;
    }

    GameState turn(StringBuilder output) {
        switch (this.objNum) {
            case 13: {
                output.append("Thud.\n");
                this.data.map[21] = this.data.map[21] | 4;
                break;
            }
            default: {
                output.append("You cannot do that!\n");
            }
        }
        return GameState.GAME_CONTINUES;
    }

    GameState hit(StringBuilder output) {
        switch (this.objNum) {
            case 10: {
                output.append("You kill the squirrel.\n");
                return GameState.GAME_LOST;
            }
            case 16: {
                this.data.seenscientist = false;
                this.data.objects[16] = -1;
                output.append("He will not bother you again.\n");
                break;
            }
            default: {
                output.append("You cannot do that!\n");
            }
        }
        return GameState.GAME_CONTINUES;
    }

    GameState kill(StringBuilder output) {
        output.append("No strong violence please. This is a family game.\n");
        return GameState.GAME_CONTINUES;
    }

    GameState pour(StringBuilder output) {
        switch (this.objNum) {
            case 17: {
                switch (this.data.room) {
                    case 6: {
                        output.append("The potion has been neutralised.\n");
                        return GameState.GAME_WON;
                    }
                }
                output.append("The potion poisons the land.\n");
                return GameState.GAME_LOST;
            }
            case 20: {
                output.append("The bottle is empty.\n");
                break;
            }
            default: {
                output.append("You cannot do that!\n");
            }
        }
        return GameState.GAME_CONTINUES;
    }

    GameState drink(StringBuilder output) {
        switch (this.objNum) {
            case 17: {
                output.append("You die instantly.");
                return GameState.GAME_LOST;
            }
            case 20: {
                return this.pour(output);
            }
        }
        output.append("You cannot do that!\n");
        return GameState.GAME_CONTINUES;
    }

    GameState throwObject(StringBuilder output) {
        if ((this.objNum <= 8 || this.objNum == 20) && this.data.room == 9) {
            this.objNum = 10;
            return this.hit(output);
        }
        return this.drop(output);
    }

    GameState look(StringBuilder output) {
        switch (this.objNum) {
            case 4: {
                return this.read(output);
            }
            case 0: {
                if (this.data.pilleaten || this.data.objects[9] != -1) break;
                return this.take(output);
            }
        }
        output.append("Nothing.\n");
        return GameState.GAME_CONTINUES;
    }

    GameState drop(StringBuilder output) {
        block0 : switch (this.objNum) {
            case 20: {
                switch (this.data.room) {
                    case 12: {
                        if (this.data.dropInventory(20, output)) {
                            output.append("You recycle the bottle. ").append("Thank you for being kind to the nature!\n");
                            this.data.objects[20] = -1;
                            break block0;
                        }
                    }
                    case 28: 
                    case 29: {
                        output.append("Throwing away a perfectly recyclable bottle? ").append("No way!\n");
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 30: {
                        output.append("Someone might get hurt!\n");
                        break block0;
                    }
                }
                output.append("Please recycle the bottle.\n");
                break;
            }
            case 17: {
                if (this.data.bothbottles > 0) {
                    output.append("You dare not drop the potion in its current state!\n");
                    break;
                }
            }
            default: {
                if (!this.data.dropInventory(this.objNum, output)) break;
                output.append("Dropped.\n");
            }
        }
        return GameState.GAME_CONTINUES;
    }

    GameState license(StringBuilder output) {
        output.append("This program is free software; you can redistribute it ").append("and/or modify it under the terms of the GNU General Public ").append("License as published by the Free Software Foundation, ").append("version 2.\n\n").append("This program is distributed in the hope that it will be ").append("useful, but WITHOUT ANY WARRANTY; without even the implied ").append("warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR ").append("PURPOSE.  See the GNU General Public License for more ").append("details.\n\n").append("You should have received a copy of the GNU General Public ").append("License along with this program; if not, write to the Free ").append("Software Foundation, Inc., 59 Temple Place, Suite 330, ").append("Boston, MA  02111-1307  USA\n");
        return GameState.GAME_CONTINUES;
    }

    GameState quit(StringBuilder output) {
        output.append("You leave for your home country. In the distance, you ").append("can hear the evil scientist laughing mercilessly as he ").append("unleashes his horrible magical potion on the land.\n");
        return GameState.GAME_LOST;
    }

    String describeRoom() {
        StringBuilder output = new StringBuilder();
        GameRoom.printRoom(this.data, output);
        return output.toString();
    }

    public static enum GameState {
        GAME_CONTINUES,
        GAME_LOST,
        GAME_WON;

    }
}

