/*
 * Decompiled with CFR 0.152.
 */
package se.pp.softwolves.games;

public class GameData {
    static final int INVENTORY = 2;
    static final int OBJECTS = 21;
    static final int MAPSIZE = 30;
    static final int[] DEFAULT_ROOMS = new int[]{1, 2, 3, 7, 8, 9, 13, 14, 15, -1, 9, 18, 16, -1, 24, 28, 19, 25, 26, 20, -1};
    static final int EXIT_NORTH = 1;
    static final int EXIT_SOUTH = 2;
    static final int EXIT_WEST = 4;
    static final int EXIT_EAST = 8;
    static final int[] DEFAULT_MAP = new int[]{10, 12, 6, 6, 10, 4, 3, 2, 3, 3, 15, 6, 9, 5, 1, 9, 15, 7, 10, 10, 14, 8, 15, 7, 1, 9, 5, 8, 13, 4};
    int room = 1;
    int[] inventory = new int[2];
    int[] objects;
    boolean pilleaten;
    boolean seenscientist;
    int[] map;
    int roadvisit;
    int bothbottles;

    public GameData() {
        int i;
        for (i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = -1;
        }
        this.objects = new int[21];
        for (i = 0; i < this.objects.length; ++i) {
            this.objects[i] = DEFAULT_ROOMS[i];
        }
        this.pilleaten = false;
        this.seenscientist = false;
        this.map = new int[30];
        for (i = 0; i < this.map.length; ++i) {
            this.map[i] = DEFAULT_MAP[i];
        }
        this.roadvisit = 0;
        this.bothbottles = 0;
    }

    boolean findObject(int objNum, boolean checkInventory) {
        if (this.objects[objNum] == this.room) {
            return true;
        }
        if (checkInventory) {
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] != objNum) continue;
                return true;
            }
        }
        return false;
    }

    boolean addInventory(int objNum, StringBuilder output) {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] != -1) continue;
            this.inventory[i] = objNum;
            this.objects[objNum] = -1;
            return true;
        }
        output.append("It is too heavy.\n");
        return false;
    }

    boolean dropInventory(int objNum, StringBuilder output) {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] != objNum) continue;
            this.inventory[i] = -1;
            this.objects[objNum] = this.room;
            return true;
        }
        output.append("You are not carrying that.\n");
        return false;
    }
}

