
#include "input.h"
#include "game.h"
#include "output.h"

# define VERBS 29

static const struct verb_s
{
const unsigned char len;
const char *s;
unsigned char verbnum;
} verbs[VERBS] =
{
  { 1, "n", V_N },
  { 1, "s", V_S },
  { 1, "e", V_E },
  { 1, "w", V_W },
  { 1, "i", V_I },
  { 4, "take", V_TAKE },
  { 7, "pick up", V_TAKE },
  { 4, "lift", V_LIFT },
  { 4, "read", V_READ },
  { 7, "talk to", V_TALKTO },
  { 6, "unlock", V_UNLOCK },
  { 4, "open", V_UNLOCK },
  { 4, "turn", V_TURN },
  { 3, "hit", V_HIT },
  { 5, "punch", V_HIT },
  { 4, "kick", V_HIT },
  { 4, "kill", V_KILL },
  { 4, "pour", V_POUR },
  { 5, "empty", V_POUR },
  { 5, "drink", V_DRINK },
  { 5, "throw", V_THROW },
  { 7, "look at", V_LOOK },
  { 4, "look", V_LOOK },
  { 7, "examine", V_LOOK },
  { 4, "drop", V_DROP },
  { 7, "license", V_LICENSE },
  { 7, "licence", V_LICENSE },
  { 4, "quit", V_QUIT },
  { 4, "exit", V_QUIT },
};

unsigned char getinput(void)
{
  while (1)
  {
    NR unsigned char i;
    NR const struct verb_s *verb;
    fputs("Your turn? ", stdout);
    fgets(input, 1024, stdin);
    input[1023] = 0;
    input[strlen(input) - 1] = 0;
    PUTCHAR('\n');
    verb = verbs;
    for (i = VERBS; i; -- i, ++ verb)
    {
      NR unsigned char n;
      NR char *p;
      n = verb->len; /* Verb length */
      p = input + n; /* First character after verb */
      if (!strncmp(input, verb->s, n) && (!*p || ' ' == *p))
      {
        if (' ' == *p)
        {
          object_string = p + 1;
        }
        else
        {
          object_string = NULL;
        }
        return verb->verbnum;
      }
    }
    PUTS("I do not understand.");
  }
}
